import { StyleSheet, Dimensions, Platform, I18nManager } from "react-native";
import dpr from "../Utilities/CustomStyleAttribute/dpr";
const { height } = Dimensions.get("window");

export const homeStyle = StyleSheet.create({
    body: {
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
        marginBottom: dpr(190),
    },
    text: {
        fontSize: dpr(16),
        textAlign: "left",
        paddingLeft: 5,
        margin: dpr(10),
    },
    header: {
        flexDirection: "row",
        alignItems: "center",
    },
    searchContainer: {
        borderBottomWidth: 1,
        position: "absolute",
        top: dpr(14),
        right: dpr(24),
        width: dpr(250, "w"),
        height: dpr(30),
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        paddingHorizontal: 5,
        borderColor: "#898989",
        paddingBottom: dpr(4),
    },
    searchTextField: {
        width: dpr(250, "w") - dpr(25),
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(16),
        color: "#C4C4C4",
        textAlign: I18nManager.isRTL ? "right" : "left",
    },
    searchTextFieldColor: (height) => ({
        color: Platform.OS === "android" ? "#9E9E9E" : "#C4C4C4",
        marginBottom: height < 684 ? -1 : 0,
        textAlign: "left"
    }),
    searchIcon: {
        position: "absolute",
        top: dpr(0),
        right: dpr(0),
        height: dpr(30),
        flexDirection: "row",
        alignItems: "center",
    },
});
